<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:26.082053892 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Neoverse-N3" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleNeoverseN3CPU_CYCLES &gt; 0), ($InstructionsPerCycleNeoverseN3INST_RETIRED / $InstructionsPerCycleNeoverseN3CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesNeoverseN3CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesNeoverseN3STALL_FRONTEND / $FrontendStalledCyclesNeoverseN3CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesNeoverseN3CPU_CYCLES &gt; 0), min(($BackendStalledCyclesNeoverseN3STALL_BACKEND / $BackendStalledCyclesNeoverseN3CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundNeoverseN3CPU_CYCLES &gt; 0), min((($FrontendBoundNeoverseN3STALL_SLOT_FRONTEND / (5 * $FrontendBoundNeoverseN3CPU_CYCLES)) - ($FrontendBoundNeoverseN3STALL_FRONTEND_FLUSH / $FrontendBoundNeoverseN3CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
        <series color="255,0,229" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundNeoverseN3CPU_CYCLES &gt; 0), min(($BackendBoundNeoverseN3STALL_SLOT_BACKEND / (5 * $BackendBoundNeoverseN3CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringNeoverseN3CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringNeoverseN3OP_SPEC &gt; 0), min(((1 - ($RetiringNeoverseN3STALL_SLOT / ($RetiringNeoverseN3CPU_CYCLES * 5))) * ($RetiringNeoverseN3OP_RETIRED / $RetiringNeoverseN3OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,25" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationNeoverseN3CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationNeoverseN3OP_SPEC &gt; 0), min((((1 - ($BadSpeculationNeoverseN3STALL_SLOT / (5 * $BadSpeculationNeoverseN3CPU_CYCLES))) * (1 - ($BadSpeculationNeoverseN3OP_RETIRED / $BadSpeculationNeoverseN3OP_SPEC))) + ($BadSpeculationNeoverseN3STALL_FRONTEND_FLUSH / $BadSpeculationNeoverseN3CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageNeoverseN3OP_SPEC &gt; 0), min(($RetiredOperationsPercentageNeoverseN3OP_RETIRED / $RetiredOperationsPercentageNeoverseN3OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundNeoverseN3STALL_FRONTEND &gt; 0), min(($FrontendCoreBoundNeoverseN3STALL_FRONTEND_CPUBOUND / $FrontendCoreBoundNeoverseN3STALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundNeoverseN3STALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundNeoverseN3STALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundNeoverseN3STALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Core Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundNeoverseN3STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundNeoverseN3STALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundNeoverseN3STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting input from the branch prediction unit" expression="if(($FrontendCoreFlowBoundNeoverseN3STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlowBoundNeoverseN3STALL_FRONTEND_FLOW / $FrontendCoreFlowBoundNeoverseN3STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flow Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Memory Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction cache misses" expression="if(($FrontendMemCacheBoundNeoverseN3STALL_FRONTEND_MEMBOUND &gt; 0), min((($FrontendMemCacheBoundNeoverseN3STALL_FRONTEND_L1I + $FrontendMemCacheBoundNeoverseN3STALL_FRONTEND_MEM) / $FrontendMemCacheBoundNeoverseN3STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem Cache Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundNeoverseN3STALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundNeoverseN3STALL_FRONTEND_TLB / $FrontendMemTLBBoundNeoverseN3STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Mem Cache Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 1 instruction cache misses" expression="if((($FrontendCacheL1IBoundNeoverseN3STALL_FRONTEND_L1I + $FrontendCacheL1IBoundNeoverseN3STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL1IBoundNeoverseN3STALL_FRONTEND_L1I / ($FrontendCacheL1IBoundNeoverseN3STALL_FRONTEND_L1I + $FrontendCacheL1IBoundNeoverseN3STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L1I Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 2 instruction cache misses" expression="if((($FrontendCacheL2IBoundNeoverseN3STALL_FRONTEND_L1I + $FrontendCacheL2IBoundNeoverseN3STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL2IBoundNeoverseN3STALL_FRONTEND_MEM / ($FrontendCacheL2IBoundNeoverseN3STALL_FRONTEND_L1I + $FrontendCacheL2IBoundNeoverseN3STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L2I Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKINeoverseN3INST_RETIRED &gt; 0), (($L1ICacheMPKINeoverseN3L1I_CACHE_REFILL / $L1ICacheMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageNeoverseN3L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageNeoverseN3L1I_CACHE_REFILL / $L1ICacheMissPercentageNeoverseN3L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Instruction Unified Cache Effectiveness (Frontend Cache L2I Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache instruction accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2ICacheMPKINeoverseN3INST_RETIRED &gt; 0), (($L2ICacheMPKINeoverseN3L2I_CACHE_REFILL / $L2ICacheMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="L2I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Instruction Unified Cache Effectiveness (Frontend Cache L2I Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache instruction accesses missed to the total number of level 2 cache instruction accesses. This gives an indication of the effectiveness of instruction accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2ICacheMissPercentageNeoverseN3L2I_CACHE &gt; 0), min(($L2ICacheMissPercentageNeoverseN3L2I_CACHE_REFILL / $L2ICacheMissPercentageNeoverseN3L2I_CACHE), 1), 0)" name="L2I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKINeoverseN3INST_RETIRED &gt; 0), (($ITLBMPKINeoverseN3ITLB_WALK / $ITLBMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKINeoverseN3INST_RETIRED &gt; 0), (($L1InstructionTLBMPKINeoverseN3L1I_TLB_REFILL / $L1InstructionTLBMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageNeoverseN3L1I_TLB &gt; 0), min(($ITLBWalkPercentageNeoverseN3ITLB_WALK / $ITLBWalkPercentageNeoverseN3L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageNeoverseN3L1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageNeoverseN3ITLB_WALK_LARGE / $ITLBWalkLargePagePercentageNeoverseN3L1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageNeoverseN3L1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageNeoverseN3ITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageNeoverseN3L1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageNeoverseN3L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageNeoverseN3L1I_TLB_REFILL / $L1InstructionTLBMissPercentageNeoverseN3L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesNeoverseN3ITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesNeoverseN3ITLB_STEP / $ITLBWalkAverageDepthOfAccessesNeoverseN3ITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyNeoverseN3ITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyNeoverseN3ITLB_WALK_PERCYC / $ITLBWalkAverageLatencyNeoverseN3ITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($BackendCoreBoundNeoverseN3STALL_BACKEND &gt; 0), min(($BackendCoreBoundNeoverseN3STALL_BACKEND_CPUBOUND / $BackendCoreBoundNeoverseN3STALL_BACKEND), 1), 0)" name="Backend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundNeoverseN3STALL_BACKEND &gt; 0), min(($BackendMemoryBoundNeoverseN3STALL_BACKEND_MEMBOUND / $BackendMemoryBoundNeoverseN3STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend as the rename unit registers are unavailable" expression="if(($BackendCoreRenameBoundNeoverseN3STALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreRenameBoundNeoverseN3STALL_BACKEND_RENAME / $BackendCoreRenameBoundNeoverseN3STALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Rename Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Register Rename Effectiveness (Backend Core Rename Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the percentage of rename stall cycles due to vector register rename availability" expression="if(($VectorRegisterRenamePercentageNeoverseN3STALL_BACKEND_RENAME &gt; 0), min(($VectorRegisterRenamePercentageNeoverseN3IMP_STALL_BACKEND_RENAME_VRF / $VectorRegisterRenamePercentageNeoverseN3STALL_BACKEND_RENAME), 1), 0)" name="Vector Register Rename Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the percentage of rename stall cycles due to flag register rename availability" expression="if(($FlagRegisterRenamePercentageNeoverseN3STALL_BACKEND_RENAME &gt; 0), min(($FlagRegisterRenamePercentageNeoverseN3IMP_STALL_BACKEND_RENAME_FRF / $FlagRegisterRenamePercentageNeoverseN3STALL_BACKEND_RENAME), 1), 0)" name="Flag Register Rename Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the percentage of rename stall cycles due to GPR register rename availability" expression="if(($IntegerRegisterRenamePercentageNeoverseN3STALL_BACKEND_RENAME &gt; 0), min(($IntegerRegisterRenamePercentageNeoverseN3IMP_STALL_BACKEND_RENAME_GRF / $IntegerRegisterRenamePercentageNeoverseN3STALL_BACKEND_RENAME), 1), 0)" name="Integer Register Rename Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Main Commit Queue Effectiveness (Backend Core Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the percentage of backend stall cycles where no commit queue resource was available" expression="if(($CommitQueueStallPercentageNeoverseN3STALL_BACKEND_CPUBOUND &gt; 0), min(($CommitQueueStallPercentageNeoverseN3IMP_STALL_BACKEND_MCQ / $CommitQueueStallPercentageNeoverseN3STALL_BACKEND_CPUBOUND), 1), 0)" name="Commit Queue Stall Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundNeoverseN3STALL_BACKEND &gt; 0), min(($BackendBusyBoundNeoverseN3STALL_BACKEND_BUSY / $BackendBusyBoundNeoverseN3STALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused by data cache misses" expression="if(($BackendMemoryCacheBoundNeoverseN3STALL_BACKEND_MEMBOUND &gt; 0), min((($BackendMemoryCacheBoundNeoverseN3STALL_BACKEND_L1D + $BackendMemoryCacheBoundNeoverseN3STALL_BACKEND_MEM) / $BackendMemoryCacheBoundNeoverseN3STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Cache Bound" units="percent"/>
        <series color="153,0,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemoryTLBBoundNeoverseN3STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryTLBBoundNeoverseN3STALL_BACKEND_TLB / $BackendMemoryTLBBoundNeoverseN3STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory TLB Bound" units="percent"/>
        <series color="0,255,153" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemoryStoreBoundNeoverseN3STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryStoreBoundNeoverseN3STALL_BACKEND_ST / $BackendMemoryStoreBoundNeoverseN3STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Store Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Cache Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 1 data cache misses" expression="if((($BackendCacheL1DBoundNeoverseN3STALL_BACKEND_L1D + $BackendCacheL1DBoundNeoverseN3STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL1DBoundNeoverseN3STALL_BACKEND_L1D / ($BackendCacheL1DBoundNeoverseN3STALL_BACKEND_L1D + $BackendCacheL1DBoundNeoverseN3STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L1D Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 2 data cache misses" expression="if((($BackendCacheL2DBoundNeoverseN3STALL_BACKEND_L1D + $BackendCacheL2DBoundNeoverseN3STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL2DBoundNeoverseN3STALL_BACKEND_MEM / ($BackendCacheL2DBoundNeoverseN3STALL_BACKEND_L1D + $BackendCacheL2DBoundNeoverseN3STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L2D Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKINeoverseN3INST_RETIRED &gt; 0), (($L1DCacheMPKINeoverseN3L1D_CACHE_REFILL / $L1DCacheMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageNeoverseN3L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageNeoverseN3L1D_CACHE_REFILL / $L1DCacheMissPercentageNeoverseN3L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Data Unified Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKINeoverseN3INST_RETIRED &gt; 0), (($L2DCacheMPKINeoverseN3L2D_CACHE_REFILL / $L2DCacheMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Data Unified Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageNeoverseN3L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageNeoverseN3L2D_CACHE_REFILL / $L2DCacheMissPercentageNeoverseN3L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKINeoverseN3INST_RETIRED &gt; 0), (($L3CacheMPKINeoverseN3L3D_CACHE_REFILL / $L3CacheMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageNeoverseN3L3D_CACHE &gt; 0), min(($L3CacheMissPercentageNeoverseN3L3D_CACHE_REFILL / $L3CacheMissPercentageNeoverseN3L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKINeoverseN3INST_RETIRED &gt; 0), (($LLCacheReadMPKINeoverseN3LL_CACHE_MISS_RD / $LLCacheReadMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageNeoverseN3LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageNeoverseN3LL_CACHE_MISS_RD / $LLCacheReadMissPercentageNeoverseN3LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageNeoverseN3LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageNeoverseN3LL_CACHE_RD - $LLCacheReadHitPercentageNeoverseN3LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageNeoverseN3LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKINeoverseN3INST_RETIRED &gt; 0), (($DTLBMPKINeoverseN3DTLB_WALK / $DTLBMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKINeoverseN3INST_RETIRED &gt; 0), (($L1DataTLBMPKINeoverseN3L1D_TLB_REFILL / $L1DataTLBMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKINeoverseN3INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKINeoverseN3L2D_TLB_REFILL / $L2UnifiedTLBMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageNeoverseN3L1D_TLB &gt; 0), min(($DTLBWalkPercentageNeoverseN3DTLB_WALK / $DTLBWalkPercentageNeoverseN3L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageNeoverseN3L1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageNeoverseN3DTLB_WALK_LARGE / $DTLBWalkLargePagePercentageNeoverseN3L1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageNeoverseN3L1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageNeoverseN3DTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageNeoverseN3L1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageNeoverseN3L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageNeoverseN3L1D_TLB_REFILL / $L1DataTLBMissPercentageNeoverseN3L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageNeoverseN3L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageNeoverseN3L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageNeoverseN3L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesNeoverseN3DTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesNeoverseN3DTLB_STEP / $DTLBWalkAverageDepthOfAccessesNeoverseN3DTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyNeoverseN3DTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyNeoverseN3DTLB_WALK_PERCYC / $DTLBWalkAverageLatencyNeoverseN3DTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Atomics Effectiveness (Backend Memory Bound) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of failed compare and swap instructions speculatively executed locally to the PE that do not update the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearFailPercentageNeoverseN3CAS_NEAR_SPEC &gt; 0), min((1 - ($CompareAndSwapNearFailPercentageNeoverseN3CAS_NEAR_PASS / $CompareAndSwapNearFailPercentageNeoverseN3CAS_NEAR_SPEC)), 1), 0)" name="Compare and Swap Near Fail Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of passed compare and swap instructions speculatively executed locally to the PE that updated the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearPassPercentageNeoverseN3CAS_NEAR_SPEC &gt; 0), min(($CompareAndSwapNearPassPercentageNeoverseN3CAS_NEAR_PASS / $CompareAndSwapNearPassPercentageNeoverseN3CAS_NEAR_SPEC), 1), 0)" name="Compare and Swap Near Pass Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageNeoverseN3INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageNeoverseN3ISB_SPEC + $BarrierOperationsPercentageNeoverseN3DSB_SPEC) + $BarrierOperationsPercentageNeoverseN3DMB_SPEC) / $BarrierOperationsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageNeoverseN3INST_SPEC &gt; 0), min(($BranchOperationsPercentageNeoverseN3PC_WRITE_SPEC / $BranchOperationsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageNeoverseN3INST_SPEC &gt; 0), min(($CryptoOperationsPercentageNeoverseN3CRYPTO_SPEC / $CryptoOperationsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageNeoverseN3INST_SPEC &gt; 0), min((($IntegerOperationsPercentageNeoverseN3DP_SPEC - $IntegerOperationsPercentageNeoverseN3DSB_SPEC) / $IntegerOperationsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageNeoverseN3INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageNeoverseN3VFP_SPEC / $FloatingPointOperationsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageNeoverseN3INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageNeoverseN3ASE_SPEC / $AdvancedSIMDOperationsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageNeoverseN3INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageNeoverseN3SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageNeoverseN3INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageNeoverseN3INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageNeoverseN3FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageNeoverseN3INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageNeoverseN3INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageNeoverseN3FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageNeoverseN3INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageNeoverseN3INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageNeoverseN3FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageNeoverseN3INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageNeoverseN3INST_SPEC &gt; 0), min(($LoadOperationsPercentageNeoverseN3LD_SPEC / $LoadOperationsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageNeoverseN3INST_SPEC &gt; 0), min(($StoreOperationsPercentageNeoverseN3ST_SPEC / $StoreOperationsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageNeoverseN3INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageNeoverseN3RC_LD_SPEC / $LoadAcquireInstructionsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageNeoverseN3INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageNeoverseN3RC_ST_SPEC / $StoreReleaseInstructionsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageNeoverseN3INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageNeoverseN3STREX_SPEC / $StoreExclusiveInstructionsPercentageNeoverseN3INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Issue Queue Effectiveness (Retiring) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the percentage of backend stall cycles where the oldest operation was a load or store operation" expression="if(($LoadStoreIQStallPercentageNeoverseN3STALL_BACKEND_BUSY &gt; 0), min(($LoadStoreIQStallPercentageNeoverseN3IMP_STALL_BACKEND_IQ_LS / $LoadStoreIQStallPercentageNeoverseN3STALL_BACKEND_BUSY), 1), 0)" name="Load/Store IQ Stall Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the percentage of backend stall cycles where the oldest operation was an integer operation" expression="if(($IntegerSXIQStallPercentageNeoverseN3STALL_BACKEND_BUSY &gt; 0), min(($IntegerSXIQStallPercentageNeoverseN3IMP_STALL_BACKEND_IQ_SX / $IntegerSXIQStallPercentageNeoverseN3STALL_BACKEND_BUSY), 1), 0)" name="Integer SX IQ Stall Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the percentage of backend stall cycles where the oldest operation was an integer operation" expression="if(($IntegerMXIQStallPercentageNeoverseN3STALL_BACKEND_BUSY &gt; 0), min(($IntegerMXIQStallPercentageNeoverseN3IMP_STALL_BACKEND_IQ_MX / $IntegerMXIQStallPercentageNeoverseN3STALL_BACKEND_BUSY), 1), 0)" name="Integer MX IQ Stall Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the percentage of backend stall cycles where the oldest operation was a vector operation" expression="if(($VectorIQStallPercentageNeoverseN3STALL_BACKEND_BUSY &gt; 0), min(($VectorIQStallPercentageNeoverseN3IMP_STALL_BACKEND_IQ_VX / $VectorIQStallPercentageNeoverseN3STALL_BACKEND_BUSY), 1), 0)" name="Vector IQ Stall Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKINeoverseN3INST_RETIRED &gt; 0), (($BranchMPKINeoverseN3BR_MIS_PRED_RETIRED / $BranchMPKINeoverseN3INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Neoverse-N3)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageNeoverseN3BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageNeoverseN3BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageNeoverseN3BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageNeoverseN3BR_RETIRED &gt; 0), min(($BranchDirectPercentageNeoverseN3BR_IMMED_RETIRED / $BranchDirectPercentageNeoverseN3BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageNeoverseN3BR_RETIRED &gt; 0), min(($BranchIndirectPercentageNeoverseN3BR_IND_RETIRED / $BranchIndirectPercentageNeoverseN3BR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageNeoverseN3BR_RETIRED &gt; 0), min(($BranchReturnPercentageNeoverseN3BR_RETURN_RETIRED / $BranchReturnPercentageNeoverseN3BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_core_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Neoverse_N3_metric_bad_speculation" />
    <select-metric id="ARMv9_Neoverse_N3_metric_barrier_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_branch_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_branch_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_cas_near_fail_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_cas_near_pass_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_crypto_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Neoverse_N3_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Neoverse_N3_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_fp16_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_fp32_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_fp64_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Neoverse_N3_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Neoverse_N3_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_ipc" />
    <select-metric id="ARMv9_Neoverse_N3_metric_iq_stall_lsu_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_iq_stall_mx_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_iq_stall_sx_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_iq_stall_vpu_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_itlb_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Neoverse_N3_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Neoverse_N3_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l2d_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l2i_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l2i_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Neoverse_N3_metric_load_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_mcq_stall_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_rename_stall_flags_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_rename_stall_int_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_rename_stall_vec_ratio" />
    <select-metric id="ARMv9_Neoverse_N3_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Neoverse_N3_metric_retiring" />
    <select-metric id="ARMv9_Neoverse_N3_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_simd_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_store_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_strex_percentage" />
    <select-metric id="ARMv9_Neoverse_N3_metric_sve_all_percentage" />
</template>
